{********************************************
; File: LineEdit.p
;
;
; Copyright Apple Computer, Inc. 1986-90
; All Rights Reserved
;
********************************************}

UNIT LINEEDIT;
INTERFACE
USES TYPES,QUICKDRAW,EVENTS;
CONST


{ Error Codes }
leDupStrtUpErr = $1401;  { duplicate LEStartup call }
leResetError = $1402;  { can't reset Line Edit }
leNotActiveErr = $1403;  { Line Edit not active }
leScrapErr = $1404;  { desk scrap too big to copy }

{ Justification Codes }
leJustLeft = $0000;
leJustCenter = $0001;
leJustFill = $0002;
leJustRight = $FFFF;

TYPE
LERecHndl = ^LERecPtr;
LERecPtr = ^LERec;
LERec = RECORD
    leLineHandle : Handle;
    leLength : Integer;
    leMaxLength : Integer;
    leDestRect : Rect;
    leViewRect : Rect;
    lePort : GrafPortPtr;
    leLineHite : Integer;
    leBaseHite : Integer;
    leSelStart : Integer;
    leSelEnd : Integer;
    leActFlg : Integer;
    leCarAct : Integer;
    leCarOn : Integer;
    leCarTime : Longint;
    leHiliteHook : VoidProcPtr;
    leCaretHook : VoidProcPtr;
    leJust : Integer;
    lePWChar : Integer;
END;
FUNCTION GetLEDefProc  : Ptr ;
PROCEDURE LEActivate ( leRecHandle:LERecHndl)  ;
PROCEDURE LEBootInit   ;
PROCEDURE LEClick ( eventPtr:EventRecord; leRecHandle:LERecHndl)  ;
PROCEDURE LECopy ( leRecHandle:LERecHndl)  ;
PROCEDURE LECut ( leRecHandle:LERecHndl)  ;
PROCEDURE LEDeactivate ( leRecHandle:LERecHndl)  ;
PROCEDURE LEDelete ( leRecHandle:LERecHndl)  ;
PROCEDURE LEDispose ( leRecHandle:LERecHndl)  ;
PROCEDURE LEFromScrap   ;
FUNCTION LEGetScrapLen  : Integer ;
FUNCTION LEGetTextHand ( leRecHandle:LERecHndl) : Handle ;
FUNCTION LEGetTextLen ( leRecHandle:LERecHndl) : Integer ;
PROCEDURE LEIdle ( leRecHandle:LERecHndl)  ;
PROCEDURE LEInsert ( textPtr:Ptr; textLength:Integer; leRecHandle:LERecHndl)  ;
PROCEDURE LEKey ( theKey:CHAR; modifiers:Integer; leRecHandle:LERecHndl)  ;
FUNCTION LENew ( destRectPtr:Rect; viewRectPtr:Rect; maxTextLen:Integer) : LERecHndl ;
PROCEDURE LEPaste ( leRecHandle:LERecHndl)  ;
PROCEDURE LEReset   ;
FUNCTION LEScrapHandle  : Handle ;
PROCEDURE LESetCaret ( caretProcPtr:VoidProcPtr; leRecHandle:LERecHndl)  ;
PROCEDURE LESetHilite ( hiliteProcPtr:VoidProcPtr; leRecHandle:LERecHndl)  ;
PROCEDURE LESetJust ( just:Integer; leRecHandle:LERecHndl)  ;
PROCEDURE LESetScrapLen ( newLength:Integer)  ;
PROCEDURE LESetSelect ( selStart:Integer; selEnd:Integer; leRecHandle:LERecHndl)  ;
PROCEDURE LESetText ( textPtr:Ptr; textLength:Integer; leRecHandle:LERecHndl)  ;
PROCEDURE LEShutDown   ;
PROCEDURE LEStartUp ( userID:Integer; dPageAddr:Integer)  ;
FUNCTION LEStatus  : Boolean ;
PROCEDURE LETextBox ( textPtr:Ptr; textLength:Integer; rectPtr:Rect; just:Integer)  ;
PROCEDURE LETextBox2 ( textPtr:Ptr; textLength:Integer; rectPtr:Rect; just:Integer)  ;
PROCEDURE LEToScrap   ;
PROCEDURE LEUpdate ( leRecHandle:LERecHndl)  ;
FUNCTION LEVersion  : Integer ;
IMPLEMENTATION
END.
